#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//RayMarching IFS fractalMod01.fsh   by  legoushque
//https://www.shadertoy.com/view/csX3DH
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_STEPS 100
#define MAX_DIST 100.
#define SURF_DIST .001
#define TAU 6.283185
#define PI 3.141592
#define S smoothstep
#define T iTime

mat2 Rot(float a) {
    float s=sin(a), c=cos(a);
    return mat2(c, -s, s, c);
}

float sdBox(vec3 p, vec3 s) {
    p = abs(p)-s;
	return length(max(p, 0.))+min(max(p.x, max(p.y, p.z)), 0.);
}


float GetDist(vec3 p, inout vec3 orbit) {
    vec3 v = vec3(cos(iTime*.12)*sin(iTime*0.73)*4. + 5., 5.+(sin(iTime*1.23)+0.5)*5., 3.+(cos(iTime*0.24)+0.5)*5.);
    vec3 n = normalize(v);
    float scale = 2.;
    p *= scale;
    
    for(int i = 0; i < 10; i++){
    
        p = abs(p);
        float lp = length(p);
        if(orbit.x > lp) orbit.x = lp;
        if(orbit.y < lp/scale) orbit.y = lp/scale;
        
        
        p -= 2.*n*max(0., dot(n, p-n*0.6));
        scale *= 2.;
        p *= 2.;
        p += n;
        
    }
    
    float d = sdBox(p, vec3(10, 10, 10))/scale;
    
    return d;
}

float GetDist(vec3 p){
    vec3 fake;
    return GetDist(p, fake);

}

float RayMarch(vec3 ro, vec3 rd, inout int i, inout float mindist, inout vec3 orbit) {
	float dO=0.;
    mindist = length(ro);
    orbit += mindist;
    for(i=0; i<MAX_STEPS; i++) {
    	vec3 p = ro + rd*dO;
        float dS = GetDist(p, orbit);
        orbit.z = fract(orbit.z + length(p));
        if(dS < mindist) mindist = dS;
        dO += dS;
        if(dO>MAX_DIST || abs(dS)<SURF_DIST) break;
    }
    orbit = fract(orbit);
    return dO;
}

vec3 GetNormal(vec3 p) {
    vec2 e = vec2(.001, 0);
    vec3 n = GetDist(p) - 
        vec3(GetDist(p-e.xyy), GetDist(p-e.yxy),GetDist(p-e.yyx));
    
    return normalize(n);
}

vec3 GetRayDir(vec2 uv, vec3 p, vec3 l, float z) {
    vec3 
        f = normalize(l-p),
        r = normalize(cross(vec3(0,1,0), f)),
        u = cross(f,r),
        c = f*z,
        i = c + uv.x*r + uv.y*u;
    return normalize(i);
}

vec3 square_bezier(vec3 a, vec3 b, vec3 c, float t){
    return mix(mix(a, b, t), mix(a, b, t), t);

}

vec3 BG(vec3 rd){
    vec3 a = vec3(0.1, 0.6, 0.2);
    vec3 b = vec3(0.2, 0.1, 0.8);
    return mix(a, b, dot(rd, vec3(0, 1, 0)) * 0.5 + 0.5);

}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
	vec2 m = (iMouse.xy-.5*iResolution.xy)/iResolution.xy;

    vec3 ro = vec3(cos(iTime)*3., 1., 3.*sin(iTime));
    ro.yz *= Rot(-m.y*PI+1.);
    ro.xz *= Rot(-m.x*TAU);
    
    vec3 rd = GetRayDir(uv, ro, vec3(0,0.,0), 1.);
    vec3 col = vec3(0);
    int i = 0;
    float mindist;
    vec3 orbit_trap;
    float d = RayMarch(ro, rd, i, mindist, orbit_trap);
    float iter = float(i)/float(MAX_STEPS);
    vec3 a = vec3(0.7, 0.1, 0.1);
    vec3 b = vec3(0.1, 0.1, 0.7);
    vec3 c = vec3(0.1, 0.5, 0.1);
    col += BG(rd);
    col *= S(SURF_DIST*10., SURF_DIST*20., mindist);
    
    if(d<MAX_DIST) {
        vec3 p = ro + rd * d;
        vec3 n = GetNormal(p);
        vec3 r = reflect(rd, n);

        float dif = dot(n, normalize(vec3(1,2,3)))*.5+.5;
        col = vec3(1)*pow(1.-iter, 5.)*(sin(orbit_trap*TAU+iTime)*0.3+0.5);
    }
    
    col = pow(col, vec3(.4545));	// gamma correction
    
    fragColor = vec4(col,1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

